﻿package  {
  
  import flash.display.*;
  import flash.events.*;
  import flash.utils.*;
  import flash.geom.*;
  import fl.transitions.*;
  import fl.transitions.easing.*;
  import fl.motion.*;
  
  /**
   * Implements a dial with critically-damped pointer motion.
   */
  public class Dial extends MovieClip {
    
    // Constants:
    
    // min and max angle of the pointer
    public static var MIN_ANGLE : Number = -58;
    public static var MAX_ANGLE : Number = 240;
    
    // Public Properties:
    
    [Inspectable]       // bring parameter up to component inspector
    public var glowColor : uint;
    
    [Inspectable]
    public var smoothTime : Number;
    
    // Private Properties:
    
    private var velocity : NumericContainer;  // pointer's angular velocity
    private var targetAngle : Number;     // target pointer angle
    private var glowColorApplied : ColorTransform;  // applied glow color
    private var glowRect : Rectangle;     // bounds of the glow
    private var alphaTween : Tween;

    private var isActive : Boolean = false;
  
    // UI Elements:
    
    private var button : Bitmap;    // button texture
    private var glow : Bitmap;      // glow texture
    
    // Initialization:
    public function Dial() {
      velocity = new NumericContainer(0.0);
      targetAngle = MIN_ANGLE;
      glowRect = new Rectangle(0, 0, 256, 256);
      
      button = new Bitmap(new DialButton(0, 0));
      glow = new Bitmap(new DialGlow(0, 0));
      
      glowColorApplied = new ColorTransform();
      
      this.addChild(glow);
      this.addChild(button);
      
      // throw the glow to the background, so it draws underneath
      // everything
      this.setChildIndex(glow, 0);
      
      // handle frame updates
      addEventListener(Event.ENTER_FRAME, enterFrameHandler);
      
      // parameters set in the component inspector don't get set in code until 
      // the Event.INIT event is triggered, so we wait for that before
      // setting the color of the glow. also, we use loaderInfo because that's
      // the object the event is triggered on (i.e. not "this").
      loaderInfo.addEventListener(Event.INIT,
                                  function(e : Event){
                                    glowColorApplied.color = glowColor;
                                    glow.bitmapData.colorTransform(glowRect, glowColorApplied);
                 
                                    alphaTween = new Tween(glow, "alpha", None.easeNone, 0.0, 0.0, 1.0, true);
                                  });
    }

    // Public Methods:
  
    public function set enable(active : Boolean) : void {
      if(!active)
        updateDialValue(0);
    
      isActive = active;
    }
  
    public function get enable() : Boolean {
      return isActive;
    }
    
    public function updateDialValue(v : Number){
      if(isActive){
        targetAngle = RescaleRange(v);
        alphaTween.continueTo(v / 100.0, 1.0);
      }
    }

    // Protected Methods:
    
    // Private Methods:
    
    private function enterFrameHandler(e : Event){
      // damp the pointer movement
      pointer.rotation = MathHelper.smoothDamp(pointer.rotation, targetAngle, velocity, smoothTime, Time.instance.deltaTime);
      pointer.rotation = MathHelper.clamp(pointer.rotation, MIN_ANGLE, MAX_ANGLE);
    }
    
    /**
     * Takes a 0-100 value and rescales it to the range of MIN_ANGLE to MAX_ANGLE
     */
    private static function RescaleRange(value : Number) : Number {
      return ((value / 100.0) * (MAX_ANGLE - MIN_ANGLE)) + MIN_ANGLE;
    }
  }
}